using System;
using System.Windows.Forms;
using DicomObjects;
using Microsoft.VisualBasic;
namespace SCU
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : Form
	{
		internal GroupBox groupBox4;
		internal TextBox Modality;
		internal TextBox PatientID;
		internal TextBox PatientName;
		internal Label Label4;
		internal Label Label3;
		internal Label Label2;
		internal Label Label1;
		internal GroupBox GroupBox1;
		internal TextBox ServerPort;
		internal TextBox ServerIPAddress;
		internal Label Label6;
		internal Label Label5;
		internal GroupBox GroupBox3;
		internal RadioButton MaximumQuery;
		internal RadioButton MediumQuery;
		internal RadioButton MinimumQuery;
		internal Button DoQuery;
		internal TextBox Report;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		internal TextBox ExamDate;
		internal Label Label13;
		internal Label Label12;
		internal Label Label11;
		internal TextBox ExamTime;
		internal Label Label10;
		internal Label Label9;
		internal Label Label8;
		internal Label Label7;
		
		private DicomDataSetCollection nullDataSets;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.groupBox4 = new GroupBox();
			this.Modality = new TextBox();
			this.ExamDate = new TextBox();
			this.PatientID = new TextBox();
			this.PatientName = new TextBox();
			this.Label4 = new Label();
			this.Label3 = new Label();
			this.Label2 = new Label();
			this.Label1 = new Label();
			this.GroupBox1 = new GroupBox();
			this.ServerPort = new TextBox();
			this.ServerIPAddress = new TextBox();
			this.Label6 = new Label();
			this.Label5 = new Label();
			this.GroupBox3 = new GroupBox();
			this.MaximumQuery = new RadioButton();
			this.MediumQuery = new RadioButton();
			this.MinimumQuery = new RadioButton();
			this.DoQuery = new Button();
			this.Report = new TextBox();
			this.Label13 = new Label();
			this.Label12 = new Label();
			this.Label11 = new Label();
			this.ExamTime = new TextBox();
			this.Label10 = new Label();
			this.Label9 = new Label();
			this.Label8 = new Label();
			this.Label7 = new Label();
			this.groupBox4.SuspendLayout();
			this.GroupBox1.SuspendLayout();
			this.GroupBox3.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupBox4
			// 
			this.groupBox4.Controls.Add(this.Label13);
			this.groupBox4.Controls.Add(this.Label12);
			this.groupBox4.Controls.Add(this.Label11);
			this.groupBox4.Controls.Add(this.ExamTime);
			this.groupBox4.Controls.Add(this.Label10);
			this.groupBox4.Controls.Add(this.Label9);
			this.groupBox4.Controls.Add(this.Label8);
			this.groupBox4.Controls.Add(this.Label7);
			this.groupBox4.Controls.Add(this.Modality);
			this.groupBox4.Controls.Add(this.ExamDate);
			this.groupBox4.Controls.Add(this.PatientID);
			this.groupBox4.Controls.Add(this.PatientName);
			this.groupBox4.Controls.Add(this.Label4);
			this.groupBox4.Controls.Add(this.Label3);
			this.groupBox4.Controls.Add(this.Label2);
			this.groupBox4.Controls.Add(this.Label1);
			this.groupBox4.Location = new System.Drawing.Point(16, 16);
			this.groupBox4.Name = "groupBox4";
			this.groupBox4.Size = new System.Drawing.Size(288, 312);
			this.groupBox4.TabIndex = 18;
			this.groupBox4.TabStop = false;
			this.groupBox4.Text = "Queries";
			// 
			// Modality
			// 
			this.Modality.BorderStyle = BorderStyle.FixedSingle;
			this.Modality.Location = new System.Drawing.Point(120, 104);
			this.Modality.Name = "Modality";
			this.Modality.Size = new System.Drawing.Size(144, 20);
			this.Modality.TabIndex = 4;
			this.Modality.Text = "";
			// 
			// ExamDate
			// 
			this.ExamDate.BorderStyle = BorderStyle.FixedSingle;
			this.ExamDate.Location = new System.Drawing.Point(120, 160);
			this.ExamDate.Name = "ExamDate";
			this.ExamDate.Size = new System.Drawing.Size(144, 20);
			this.ExamDate.TabIndex = 3;
			this.ExamDate.Text = "";
			// 
			// PatientID
			// 
			this.PatientID.BorderStyle = BorderStyle.FixedSingle;
			this.PatientID.Location = new System.Drawing.Point(120, 74);
			this.PatientID.Name = "PatientID";
			this.PatientID.Size = new System.Drawing.Size(144, 20);
			this.PatientID.TabIndex = 2;
			this.PatientID.Text = "";
			// 
			// PatientName
			// 
			this.PatientName.BorderStyle = BorderStyle.FixedSingle;
			this.PatientName.Location = new System.Drawing.Point(120, 42);
			this.PatientName.Name = "PatientName";
			this.PatientName.Size = new System.Drawing.Size(144, 20);
			this.PatientName.TabIndex = 1;
			this.PatientName.Text = "";
			// 
			// Label4
			// 
			this.Label4.AutoSize = true;
			this.Label4.Location = new System.Drawing.Point(24, 104);
			this.Label4.Name = "Label4";
			this.Label4.Size = new System.Drawing.Size(46, 16);
			this.Label4.TabIndex = 11;
			this.Label4.Text = "Modality";
			// 
			// Label3
			// 
			this.Label3.AutoSize = true;
			this.Label3.Location = new System.Drawing.Point(24, 160);
			this.Label3.Name = "Label3";
			this.Label3.Size = new System.Drawing.Size(60, 16);
			this.Label3.TabIndex = 10;
			this.Label3.Text = "Exam Date";
			// 
			// Label2
			// 
			this.Label2.AutoSize = true;
			this.Label2.Location = new System.Drawing.Point(24, 74);
			this.Label2.Name = "Label2";
			this.Label2.Size = new System.Drawing.Size(54, 16);
			this.Label2.TabIndex = 9;
			this.Label2.Text = "Patient ID";
			// 
			// Label1
			// 
			this.Label1.AutoSize = true;
			this.Label1.Location = new System.Drawing.Point(24, 42);
			this.Label1.Name = "Label1";
			this.Label1.Size = new System.Drawing.Size(73, 16);
			this.Label1.TabIndex = 8;
			this.Label1.Text = "Patient Name";
			// 
			// GroupBox1
			// 
			this.GroupBox1.Controls.Add(this.ServerPort);
			this.GroupBox1.Controls.Add(this.ServerIPAddress);
			this.GroupBox1.Controls.Add(this.Label6);
			this.GroupBox1.Controls.Add(this.Label5);
			this.GroupBox1.Location = new System.Drawing.Point(16, 344);
			this.GroupBox1.Name = "GroupBox1";
			this.GroupBox1.Size = new System.Drawing.Size(288, 112);
			this.GroupBox1.TabIndex = 19;
			this.GroupBox1.TabStop = false;
			this.GroupBox1.Text = "Server Settings";
			// 
			// ServerPort
			// 
			this.ServerPort.BorderStyle = BorderStyle.FixedSingle;
			this.ServerPort.Location = new System.Drawing.Point(120, 68);
			this.ServerPort.Name = "ServerPort";
			this.ServerPort.Size = new System.Drawing.Size(144, 20);
			this.ServerPort.TabIndex = 6;
			this.ServerPort.Text = "104";
			// 
			// ServerIPAddress
			// 
			this.ServerIPAddress.BorderStyle = BorderStyle.FixedSingle;
			this.ServerIPAddress.Location = new System.Drawing.Point(120, 30);
			this.ServerIPAddress.Name = "ServerIPAddress";
			this.ServerIPAddress.Size = new System.Drawing.Size(144, 20);
			this.ServerIPAddress.TabIndex = 5;
			this.ServerIPAddress.Text = "localhost";
			// 
			// Label6
			// 
			this.Label6.AutoSize = true;
			this.Label6.Location = new System.Drawing.Point(24, 72);
			this.Label6.Name = "Label6";
			this.Label6.Size = new System.Drawing.Size(68, 16);
			this.Label6.TabIndex = 1;
			this.Label6.Text = "Port Number";
			// 
			// Label5
			// 
			this.Label5.AutoSize = true;
			this.Label5.Location = new System.Drawing.Point(24, 32);
			this.Label5.Name = "Label5";
			this.Label5.Size = new System.Drawing.Size(59, 16);
			this.Label5.TabIndex = 0;
			this.Label5.Text = "IP Address";
			// 
			// GroupBox3
			// 
			this.GroupBox3.Controls.Add(this.MaximumQuery);
			this.GroupBox3.Controls.Add(this.MediumQuery);
			this.GroupBox3.Controls.Add(this.MinimumQuery);
			this.GroupBox3.Location = new System.Drawing.Point(16, 472);
			this.GroupBox3.Name = "GroupBox3";
			this.GroupBox3.Size = new System.Drawing.Size(288, 120);
			this.GroupBox3.TabIndex = 20;
			this.GroupBox3.TabStop = false;
			this.GroupBox3.Text = "Query Options";
			// 
			// MaximumQuery
			// 
			this.MaximumQuery.Location = new System.Drawing.Point(24, 80);
			this.MaximumQuery.Name = "MaximumQuery";
			this.MaximumQuery.Size = new System.Drawing.Size(168, 24);
			this.MaximumQuery.TabIndex = 9;
			this.MaximumQuery.Text = "Maximum Query (All Types)";
			// 
			// MediumQuery
			// 
			this.MediumQuery.Location = new System.Drawing.Point(24, 56);
			this.MediumQuery.Name = "MediumQuery";
			this.MediumQuery.Size = new System.Drawing.Size(216, 16);
			this.MediumQuery.TabIndex = 8;
			this.MediumQuery.Text = "Medium Query (All Type 1 and Type 2)";
			// 
			// MinimumQuery
			// 
			this.MinimumQuery.Checked = true;
			this.MinimumQuery.Location = new System.Drawing.Point(24, 24);
			this.MinimumQuery.Name = "MinimumQuery";
			this.MinimumQuery.Size = new System.Drawing.Size(168, 24);
			this.MinimumQuery.TabIndex = 7;
			this.MinimumQuery.TabStop = true;
			this.MinimumQuery.Text = "Minimum Query (All Type 1)";
			// 
			// DoQuery
			// 
			this.DoQuery.Location = new System.Drawing.Point(56, 600);
			this.DoQuery.Name = "DoQuery";
			this.DoQuery.Size = new System.Drawing.Size(216, 56);
			this.DoQuery.TabIndex = 21;
			this.DoQuery.Text = "Do MWL Query";
			this.DoQuery.Click += new System.EventHandler(this.DoQuery_Click);
			// 
			// Report
			// 
			this.Report.BorderStyle = BorderStyle.FixedSingle;
			this.Report.Location = new System.Drawing.Point(313, 22);
			this.Report.Multiline = true;
			this.Report.Name = "Report";
			this.Report.ScrollBars = ScrollBars.Vertical;
			this.Report.Size = new System.Drawing.Size(416, 634);
			this.Report.TabIndex = 22;
			this.Report.Text = "";
			// 
			// Label13
			// 
			this.Label13.AutoSize = true;
			this.Label13.Location = new System.Drawing.Point(116, 288);
			this.Label13.Name = "Label13";
			this.Label13.Size = new System.Drawing.Size(58, 16);
			this.Label13.TabIndex = 27;
			this.Label13.Text = "-HHMMSS";
			// 
			// Label12
			// 
			this.Label12.AutoSize = true;
			this.Label12.Location = new System.Drawing.Point(120, 272);
			this.Label12.Name = "Label12";
			this.Label12.Size = new System.Drawing.Size(58, 16);
			this.Label12.TabIndex = 26;
			this.Label12.Text = "HHMMSS-";
			// 
			// Label11
			// 
			this.Label11.AutoSize = true;
			this.Label11.Location = new System.Drawing.Point(120, 256);
			this.Label11.Name = "Label11";
			this.Label11.Size = new System.Drawing.Size(109, 16);
			this.Label11.TabIndex = 25;
			this.Label11.Text = "HHMMSS-HHMMSS";
			// 
			// ExamTime
			// 
			this.ExamTime.BorderStyle = BorderStyle.FixedSingle;
			this.ExamTime.Location = new System.Drawing.Point(120, 232);
			this.ExamTime.Name = "ExamTime";
			this.ExamTime.Size = new System.Drawing.Size(144, 20);
			this.ExamTime.TabIndex = 24;
			this.ExamTime.Text = "";
			// 
			// Label10
			// 
			this.Label10.AutoSize = true;
			this.Label10.Location = new System.Drawing.Point(24, 232);
			this.Label10.Name = "Label10";
			this.Label10.Size = new System.Drawing.Size(61, 16);
			this.Label10.TabIndex = 23;
			this.Label10.Text = "Exam Time";
			// 
			// Label9
			// 
			this.Label9.AutoSize = true;
			this.Label9.Location = new System.Drawing.Point(116, 216);
			this.Label9.Name = "Label9";
			this.Label9.Size = new System.Drawing.Size(73, 16);
			this.Label9.TabIndex = 22;
			this.Label9.Text = "-YYYYMMDD";
			// 
			// Label8
			// 
			this.Label8.AutoSize = true;
			this.Label8.Location = new System.Drawing.Point(120, 200);
			this.Label8.Name = "Label8";
			this.Label8.Size = new System.Drawing.Size(73, 16);
			this.Label8.TabIndex = 21;
			this.Label8.Text = "YYYYMMDD-";
			// 
			// Label7
			// 
			this.Label7.AutoSize = true;
			this.Label7.Location = new System.Drawing.Point(120, 184);
			this.Label7.Name = "Label7";
			this.Label7.Size = new System.Drawing.Size(139, 16);
			this.Label7.TabIndex = 20;
			this.Label7.Text = "YYYYMMDD-YYYYMMDD";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(744, 670);
			this.Controls.Add(this.Report);
			this.Controls.Add(this.DoQuery);
			this.Controls.Add(this.GroupBox3);
			this.Controls.Add(this.GroupBox1);
			this.Controls.Add(this.groupBox4);
			this.Name = "Form1";
			this.Text = "DO.NET Modality SCU C#2003 Example";
			this.Load += new System.EventHandler(this.Form1_Load);
			this.groupBox4.ResumeLayout(false);
			this.GroupBox1.ResumeLayout(false);
			this.GroupBox3.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}
		
		private void AppendAttributes( System.Text.StringBuilder list, string prefix, DicomDataSet ob)
		{
			DicomAttribute at;
			DicomDataSetCollection s;
			int i;
			object v;
			
			for(int j = 0; j< ob.Count; j++)
			{
				at = ob[j];			
				
				list.Append(prefix).Append("(").Append(at.Group.ToString("X4")).Append(",").Append(at.Element.ToString("X4")).Append(") : ");
				list.Append(at.Description.PadRight(30)).Append(": ");
				if( (at.Group == 0x7FE0) ) // pixel data;
						
					list.Append("Pixel data").Append("\r\n");
				else    
				{
					if( Information.VarType(at.Value)  == VariantType.Object)  // i.e. a sequence;
					{
						s = (DicomDataSetCollection)at.Value;
						if(s != null)
						{
							list.Append("Sequence of ").Append(s.Count).Append(" items:").Append("\r\n");
							for( i = 0; i < s.Count; i++)
							{
								list.Append(prefix).Append(">---------------").Append("\r\n");
								AppendAttributes(list, prefix + ">", s[i]);
							}
							list.Append(prefix).Append(">---------------");
							list.Append("\r\n");
						}
						else
						{
							list.Append("\r\n");
						}
					}
					else    
					{
						v = at.Value; // could be variant or array;
						if( (Information.VarType(v) >= VariantType.Array) )  // i.e. an array;
						{
							Array a = v as Array;
							list.Append("Multiple values :");
							list.Append("\r\n");
							list.Append("              ");

							if( Information.UBound(a, 1) > 32 )
							{
								list.Append("Array of ").Append(Information.UBound(a, 1)).Append(" elements");
							}
							else    
							{
								for( i = Information.LBound(a, 1); i<=Information.UBound(a, 1);i++)
								{
									list.Append(a.GetValue(i));
									if( i != Information.UBound(a, 1) ) list.Append(" : ");
								}
							}
							list.Append("\r\n");
						}
						else    
						{
							if( at.VR == "DA" && Information.VarType(v) != VariantType.Null )
							{
								DateTime d;
								d = (DateTime)v;
								list.Append(d.ToShortDateString());
								list.Append("\r\n");
							}
							else    
							{
								if( at.VR == "TM" && Information.VarType(v) != VariantType.Null )
								{
									DateTime d;
									d = (DateTime)v;
									list.Append(d.ToShortTimeString());
									list.Append("\r\n");
								}
								else    
								{
									list.Append(v);
									list.Append("\r\n");
								}
							}
						}
					}
				}
			}
		}

		private void AddMinimum(DicomDataSet ds, DicomDataSet seqItem)
		{
			// ============================ Type 1 Attributes ============================
			ds.Name = PatientName.Text;              // (0010, 0010) Patient Name
			ds.PatientID = PatientID.Text;           // (0010, 0020) Patient ID
			ds.Add(0x20, 0xD, "");                   // Study Instance UID
			ds.Add(0x40, 0x1001, "");                // Requested Procedure ID
			ds.Add(0x32, 0x1060, "");                // Requested Procedure Description
			seqItem.ValidationTypes = DicomObjects.Enums.ValidationTypes.ForQuery;
			// =======================  Scheduled Procedure Step SQ =======================
			seqItem.Add(0x40, 0x1, "");              // Scheduled Station AE Title
			// get StartDate
			if(ExamDate.Text != "")
				seqItem.Add(0x40, 0x2, ExamDate.Text); // Scheduled Procedure Step Start Date
			// get StartTime
			if(ExamTime.Text != "")
				seqItem.Add(0x40, 0x3, ExamTime.Text); // Scheduled Procedure Step Start Date

			seqItem.Add(0x40, 0x9, "");              // Scheduled Procedure Step ID
			seqItem.Add(0x8, 0x60, Modality.Text);   // Modality
		}

		private void AddMedium(DicomDataSet ds, DicomDataSet seqItem)
		{
			// =============== Type 1c/2 Attributes ===============
			ds.Add(0x8, 0x50, "");
			ds.Add(0x8, 0x90, "");
			ds.Add(0x8, 0x1110, nullDataSets);
			ds.Add(0x8, 0x1120, nullDataSets);

			ds.Add(0x10, 0x30, "");
			ds.Add(0x10, 0x40, "");
			ds.Add(0x10, 0x1030, "");
			ds.Add(0x10, 0x2000, "");
			ds.Add(0x10, 0x2110, "");
			ds.Add(0x10, 0x21C0, 0);
			ds.Add(0x32, 0x1060, "");
			ds.Add(0x32, 0x1064, nullDataSets);

			ds.Add(0x32, 0x1032, "");
			ds.Add(0x38, 0x10, "");
			ds.Add(0x38, 0x50, "");
			ds.Add(0x38, 0x300, "");
			ds.Add(0x38, 0x500, "");
			ds.Add(0x40, 0x1003, "");
			ds.Add(0x40, 0x1004, "");
			ds.Add(0x40, 0x3001, "");

			seqItem.Add(0x40, 6, "");
			seqItem.Add(0x40, 7, "");
			seqItem.Add(0x40, 8, nullDataSets);
			seqItem.Add(0x40, 0x10, "");
			seqItem.Add(0x40, 0x11, "");
		}

		private void AddMaximum(DicomDataSet ds, DicomDataSet seqItem)
		{
			// =============== Type 2c/3 Attributes ===============
			ds.Add(0x10, 0x101, nullDataSets);
			ds.Add(0x32, 0x1064, nullDataSets);

			seqItem.Add(0x40, 8, nullDataSets);
			seqItem.Add(0x40, 0x20, 0);
			seqItem.Add(0x32, 0x1070, "");
			seqItem.Add(0x40, 0x12, "");
		}

		private void Form1_Load(object sender, EventArgs e)
		{
			nullDataSets = new DicomDataSetCollection();
			DicomGlobal.LogToFile("C:\\Dicom Log Files\\", 0x3F);
		}

		private void DoQuery_Click(object sender, EventArgs e)
		{
			DicomQuery q = new DicomQuery();
			DicomDataSetCollection SQ = new DicomDataSetCollection();
			DicomDataSet ds = new DicomDataSet();
			DicomDataSet seqItem = new DicomDataSet();
			DicomDataSetCollection results;
			string prefix = " ";		

			Report.Text = "Waiting for Query Results, Please Wait ... ...";
			Report.Refresh();

			q.Node = ServerIPAddress.Text;
			q.Port = Convert.ToInt32(ServerPort.Text);
			q.CallingAE = "MWL_SCU";
			q.CalledAE = "MWL_SCP";
			q.Root = DicomObjects.Enums.QueryRoot.ModalityWorklist;

			if(MinimumQuery.Checked)
			{
				AddMinimum(ds, seqItem);
			}
        
			if(MediumQuery.Checked)
			{
				AddMinimum(ds, seqItem);
				AddMedium(ds, seqItem);
			}
			
			if(MaximumQuery.Checked)
			{
				AddMinimum(ds, seqItem);
				AddMedium(ds, seqItem);
				AddMaximum(ds, seqItem);
			}
        
			SQ.Add(seqItem);
			ds.Add(0x0040, 0x0100, SQ);
			
			results = q.Find(ds);
			
			if(results.Count == 0)
			{
				Report.Text = "No Results Returned";
				return;
			}

			System.Text.StringBuilder temp = new System.Text.StringBuilder(256);
			Report.Text = "";

			for(int i = 0; i < results.Count; i++)
			{
				AppendAttributes(temp, prefix, results[i]);
				temp.Append(" ============================================ ");
				temp.Append("\r\n");
			}

			Report.Text = temp.ToString();
		}
	}
}
